<?php
if (!isset($_SESSION)) {
    session_start();
}
?>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <a class="navbar-brand" href="../pages/dashboard.php">POS System</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav me-auto">
                <li class="nav-item">
                    <a class="nav-link" href="../pages/dashboard.php">
                        <i class="fas fa-tachometer-alt me-1"></i>Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="pos.php">
                        <i class="fas fa-cash-register me-1"></i>POS
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="../pages/products.php">
                        <i class="fas fa-box me-1"></i>Products
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="customers.php">
                        <i class="fas fa-users me-1"></i>Customers
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="reports.php">
                        <i class="fas fa-chart-bar me-1"></i>Reports
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="../pages/credit.php">
                        <i class="fas fa-credit-card me-1"></i>Credit Management
                    </a>
                </li>
                <?php if (hasPermission('view_settings') || hasPermission('manage_users') || hasPermission('manage_roles')): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="settingsDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-cog me-1"></i>Settings
                    </a>
                    <ul class="dropdown-menu">
                        <?php if (hasPermission('manage_users')): ?>
                        <li>
                            <a class="dropdown-item" href="users.php">
                                <i class="fas fa-user-cog me-1"></i>User Management
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (hasPermission('manage_roles')): ?>
                        <li>
                            <a class="dropdown-item" href="roles.php">
                                <i class="fas fa-user-shield me-1"></i>Roles & Permissions
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (hasPermission('view_settings')): ?>
                        <li>
                            <a class="dropdown-item" href="settings.php">
                                <i class="fas fa-sliders-h me-1"></i>System Settings
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
            </ul>
            <ul class="navbar-nav">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-user me-1"></i><?php echo htmlspecialchars($_SESSION['username']); ?>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="profile.php">
                                <i class="fas fa-id-card me-1"></i>Profile
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item" href="../auth/logout.php">
                                <i class="fas fa-sign-out-alt me-1"></i>Logout
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav> 